/**
 * @file Drv_RAM.c
 * @author 吳星萍 iris@e-besthealth.com
 * @brief  RAM調用接口
 * @version 0.1
 * @date  2020-06-17
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */

#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_Ram.h"

/**
 * @brief RAM初始化
 * @detail 將所有RAM初始為0
 *
 * @note 適用RAM大於256byte IP
 * @attention 注意
 * @warning 警告
 * @exception 异常
 */
#define RAM_BANK 8
void Drv_RamInit()
{
	_mp1h = 0;
	_mp1l = 0x80;
	while(_mp1h < RAM_BANK)
	{
		for(_tblp = 0x00;_tblp < 128;_tblp++)
		{
			_iar1 = 0;
			_mp1l++;
		}
		_mp1l = 0x80;
		_mp1h++;
	}
}